function fdr_som(sMap,fdr,cutoff)

% Visualize the neurons selected under indicated FDR using SOM

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
scrsz = get(0,'ScreenSize');
figure('Position',[scrsz(3)*1/20 scrsz(3)*1/20 scrsz(3)*7/10*(0.815/0.775) scrsz(3)*7/10])
set(gcf,'paperpositionmode','auto','color','w')
h_som=axes('position',[0.1 0.2 0.7 0.7]);
colormap(1-gray)

rug=-1*ones(size(fdr,1),1); % neurons filtered filled with white
rug(fdr<cutoff,1)=0.3; % neurons selected filled with gray

som_cplane(sMap,rug),caxis([-1 1])
title(['FDR<',num2str(cutoff)],'fontsize',20)
set(h_som,'color','none')
% marker for selected neurons
axes('position',[0.25 0.15 0.038 0.038])
som_cplane('hexa',[1 1],0.3),caxis([-1 1])
h_som1=axes('position',[0.28 0.16 0.02 0.02],'visible','off');
set(gcf,'CurrentAxes',h_som1)
text(0.5,0.5,'Nodes selected ','FontSize',12,'color','k')
% marker for filtered Nodes
axes('position',[0.25 0.1 0.038 0.038])
som_cplane('hexa',[1 1],-1),caxis([-1 1])
h_som2=axes('position',[0.28 0.11 0.02 0.02],'visible','off');
set(gcf,'CurrentAxes',h_som2)
text(0.5,0.5,'Nodes filtered ','FontSize',12,'color','k')

return
